/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.elderguardian.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.utils.MCUtils;
import insane96mcp.progressivebosses.base.Strings;
import insane96mcp.progressivebosses.setup.Config;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.ElderGuardianEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Health", description="Bonus Health and Health regeneration.")
public class HealthFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> bonusHealthConfig;
    private final ForgeConfigSpec.ConfigValue<Double> absorptionHealthConfig;
    private final ForgeConfigSpec.ConfigValue<Double> healthRegenConfig;
    public double bonusHealth = 0.5;
    public double absorptionHealth = 40.0;
    public double healthRegen = 0.5;

    public HealthFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.bonusHealthConfig = Config.builder.comment("Increase Elder Guardians' Health by this percentage (1 = +100% health)").defineInRange("Health Bonus per Difficulty", this.bonusHealth, 0.0, Double.MAX_VALUE);
        this.absorptionHealthConfig = Config.builder.comment("Adds absorption health to Elder Guradians (health that doesn't regen)").defineInRange("Absorption Health", this.absorptionHealth, 0.0, Double.MAX_VALUE);
        this.healthRegenConfig = Config.builder.comment("Health Regen per second").defineInRange("Health Regen", this.healthRegen, 0.0, Double.MAX_VALUE);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.bonusHealth = (Double)this.bonusHealthConfig.get();
        this.absorptionHealth = (Double)this.absorptionHealthConfig.get();
        this.healthRegen = (Double)this.healthRegenConfig.get();
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.bonusHealth == 0.0 && this.absorptionHealth == 0.0) {
            return;
        }
        if (!(event.getEntity() instanceof ElderGuardianEntity)) {
            return;
        }
        ElderGuardianEntity elderGuardian = (ElderGuardianEntity)event.getEntity();
        CompoundNBT nbt = elderGuardian.getPersistentData();
        if (nbt.func_74767_n("progressivebosses:difficulty")) {
            return;
        }
        nbt.func_74757_a("progressivebosses:difficulty", true);
        if (this.bonusHealth > 0.0) {
            if (elderGuardian.func_110148_a(Attributes.field_233818_a_).func_111127_a(Strings.AttributeModifiers.BONUS_HEALTH_UUID) != null) {
                return;
            }
            MCUtils.applyModifier((LivingEntity)elderGuardian, (Attribute)Attributes.field_233818_a_, (UUID)Strings.AttributeModifiers.BONUS_HEALTH_UUID, (String)"progressivebosses:bonus_health", (double)this.bonusHealth, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
        }
        if (this.absorptionHealth > 0.0) {
            elderGuardian.func_110149_m((float)this.absorptionHealth);
        }
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof ElderGuardianEntity)) {
            return;
        }
        if (this.healthRegen == 0.0) {
            return;
        }
        ElderGuardianEntity elderGuardian = (ElderGuardianEntity)event.getEntity();
        if (!elderGuardian.func_70089_S()) {
            return;
        }
        float heal = (float)this.healthRegen / 20.0f;
        elderGuardian.func_70691_i(heal);
    }
}

